import { Scissors, Mail, Phone, MapPin, Clock, Instagram, Twitter, Linkedin } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-modern">
      <div className="container">
        <div className="footer-content-modern">
          <div className="footer-section-modern">
            <div className="footer-logo-modern">
              <div className="footer-logo-icon-wrapper-modern">
                <Scissors className="footer-logo-icon-modern" size={24} />
              </div>
              <h2 className="footer-logo-text-modern">SEWLAB</h2>
            </div>
            <p className="footer-description-modern">
              Современные курсы по шитью. Развивайте навыки и создавайте уникальные вещи.
            </p>
            <div className="footer-social-modern">
              <a href="#" className="social-link-modern">
                <Instagram size={18} />
              </a>
              <a href="#" className="social-link-modern">
                <Twitter size={18} />
              </a>
              <a href="#" className="social-link-modern">
                <Linkedin size={18} />
              </a>
            </div>
          </div>
          <div className="footer-section-modern">
            <h3 className="footer-title-modern">Навигация</h3>
            <ul className="footer-links-modern">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Портфолио</a></li>
            </ul>
          </div>
          <div className="footer-section-modern">
            <h3 className="footer-title-modern">Контакты</h3>
            <ul className="footer-links-modern">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@sewlab.ru">info@sewlab.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Ткацкая, 15</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Сб: 10:00 - 20:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-modern">
          <p>&copy; 2025 SEWLAB. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

